/* ****************************************
        Mnemonics

TTS_Sequence_Start_Code ==> TTS_seq : 0x011111111
Language_Code ==> L_code ----
Prosody_Enable ==> P_en     |
Video_Enable ==> V_en       |--- TTSinputType
Lip_Shape_Enable ==> L_en   |
Trick_Mode_Enable ==> T_en _|

TTS_Sentence_Start_Code ==> TTS_sent : 0x012121212
Silence
    Silence_Duration ==> Sdur

    Gender      ____________
    Age                     |___ TTSCmmd
        Speech_Rate  _______|
    Length_of_Text ==> Ntext
    TTS_Text ==> Text

        Number_of_phonemes ==> Nphone
        Symbol_each_phoneme[] ==> Phone[]
        Dur_each_phoneme[] ==> Dur[]
        F0_contour_each_phoneme[][] ==> Ptch[][]
        Energy_contour_each_phoneme[][] ==> Energy[][]

        Sentence_Duration ==> SntDur
        Position_in_Sentence ==> PinSnt
        Offset

        Number_of_Lip_Event ==> Nlip
        Lip_in_Sentence[] ==> LinSnt[]
        Lip_shape[] ==> Lshape[]
********************************************* */


struct TTS {
	char TTS_seq_id;
	short L_code;
	char G_en;
	char A_en;
	char R_en;
	char P_en;
	char V_en;
	char L_en;
	char T_en;
	};
typedef struct TTS TTS_Data;

struct FRAME {
	short TTS_id;
	char Silence;
	short Sdur;
	struct SENTENCE *Sentence;
	};
typedef struct FRAME FRAME_Data;

struct SENTENCE {
	char Gender;
	char Age;
	char Speech_Rate;
	short Ntext;
	char *Text;
	struct PROSODY *Prosody;
	struct VIDEO *Video;
	struct LIP_SHAPE *Lip_shape;
	};
typedef struct SENTENCE SENTENCE_Data;

struct PROSODY {
	char Dur_en;
	char F0_en;
	char En_en;
	short Nphone;
	short Sphone;
	char *Phone;
	short *Dur;
	char **Ptch;
	char **Energy;
	};
typedef struct PROSODY Prosody_Data;

struct VIDEO {
	short SntDur;
	short PinSnt;
	short Offset;
	};
typedef struct VIDEO Video_Data;

struct LIP_SHAPE {
	short Nlip;
	short *LinSnt;
	char *Lshape;
	};
typedef struct LIP_SHAPE Lip_Data;

